varying vec2 		texcoord;
uniform sampler2D 	colorBuffer;
uniform sampler2D 	normalBuffer;

vec4 decode(vec4 enc)
{
    vec2 fenc = enc.xy*4.0-2.0;
    float f = dot(fenc,fenc);
    float g = sqrt(1.0-f/4.0);
    vec4 n;
    n.xy = fenc.xy*g;
    n.z = 1.0-f/2.0;
	n.w=enc.w;
    return n;
}

void main()
{
	// vignette
	vec4 encoded=texture2D(normalBuffer,texcoord.st);
	vec4 normal = decode(encoded);
	vec4 finalColor=texture2D(colorBuffer,texcoord.st);
	gl_FragColor.rgb=finalColor.rgb;

	// 0.7 < norm.z => step=0.0
	gl_FragColor.a=finalColor.a*step(normal.z,0.35);
}
